﻿using UnityEngine;
using UnityEngine.InputSystem;

[RequireComponent(typeof(Rigidbody))]       // なければ自動で追加
[RequireComponent(typeof(CapsuleCollider))] // なければ自動で追加
[RequireComponent(typeof(PlayerInput))]     // なければ自動で追加

// キー入力で移動する
public class OnKeyPressMove : MonoBehaviour
{
    //-------------------------------------
    // 移動スピード
    public float speed = 2f;
    //-------------------------------------

    private Vector2 moveInput;
    private Rigidbody rbody;

    void Awake()
    {
        // Rigidbody を取得して、回転しないように固定する
        rbody = GetComponent<Rigidbody>();
        rbody.constraints = RigidbodyConstraints.FreezeRotation;
    }

    public void OnMove(InputValue value)
    {
        // 新InputSystemから移動入力を受け取る（X=横移動、Y=前後移動）
        moveInput = value.Get<Vector2>();
    }

    void FixedUpdate()
    {
        // 現在の速度を取得
        Vector3 vel = rbody.linearVelocity;
        // 入力値から移動方向を計算（X=横移動、Z=前後移動）
        Vector3 move = new Vector3(moveInput.x, 0, moveInput.y) * speed;
        // 移動方向を反映。Y軸（ジャンプや重力）の速度はそのまま残す
        rbody.linearVelocity = new Vector3(move.x, vel.y, move.z);
    }
}
