using UnityEngine;

[RequireComponent(typeof(Rigidbody))]   // なければ自動で追加

// ずっと、回転する
public class ForeverRotate : MonoBehaviour
{
    //-------------------------------------
    // 回転スピード（X=横回転、Y=縦回転、Z=奥行き回転）
    public Vector3 speed = new Vector3(0f, 30f, 0f);
    //-------------------------------------

    private Rigidbody rbody;

    void Awake()
    {
        // Rigidbody を取得して、物理的な力の影響を受けない設定にする
        rbody = GetComponent<Rigidbody>();
        rbody.isKinematic = true;
    }

    void FixedUpdate()
    {
        // 1フレームで回す角度を計算（回転スピード × 経過時間）
        Quaternion step = Quaternion.Euler(speed * Time.fixedDeltaTime);
        // 現在の回転に加えて、次の回転を計算
        Quaternion nextRot = rbody.rotation * step;
        // Rigidbody を通して自然に回転させる
        rbody.MoveRotation(nextRot);
    }
}
