using UnityEngine;

[RequireComponent(typeof(Rigidbody))]   // なければ自動で追加

// ずっと、往復移動する
public class ForeverPingPongMove : MonoBehaviour
{
    //-------------------------------------
    // 移動スピード（X=左右、Y=上下、Z=前後）
    public Vector3 speed = new Vector3(1, 0, 0);
    // 片道の移動時間（秒）
    public float moveTime = 2.0f;
    //-------------------------------------

    private float dir = 1.0f;      // 今の移動方向（1=正方向、-1=逆方向）
    private float timer = 0.0f;    // 経過時間を数える
    private Rigidbody rbody;

    void Awake()
    {
        // Rigidbody を取得して、物理的な力の影響を受けない設定にする
        rbody = GetComponent<Rigidbody>();
        rbody.isKinematic = true;
    }

    void FixedUpdate()
    {
        // 経過時間をカウントし、一定時間ごとに方向を反転
        timer += Time.fixedDeltaTime;
        if (timer >= moveTime)
        {
            dir = -dir;    // 移動方向を逆にする
            timer = 0.0f;  // タイマーをリセット
        }

        // 次の位置を計算（現在の位置＋速さ × 向き × 経過時間）
        Vector3 nextPos = rbody.position + speed * dir * Time.fixedDeltaTime;
        // Rigidbody を通して位置を移動（物理的な衝突も自然になる）
        rbody.MovePosition(nextPos);
    }
}
