﻿using UnityEngine;

[RequireComponent(typeof(Rigidbody))]   // なければ自動で追加

// ずっと、移動する
public class ForeverMove : MonoBehaviour
{
    //-------------------------------------
    // 移動スピード（X=左右、Y=上下、Z=前後）
    public Vector3 speed = new Vector3(1f, 0f, 0f); 
    //-------------------------------------

    private Rigidbody rbody;

    void Awake()
    {
        // Rigidbody を取得して、物理的な力の影響を受けない設定にする
        rbody = GetComponent<Rigidbody>();
        rbody.isKinematic = true;
    }

    void FixedUpdate()
    {
        // 1フレームで進む位置を計算（移動スピード × 経過時間）
        Vector3 nextPos = rbody.position + speed * Time.fixedDeltaTime;
        // Rigidbody を通して位置を移動（物理的な衝突も自然になる）
        rbody.MovePosition(nextPos);
    }
}
