﻿using UnityEngine;
using UnityEngine.AI;
using UnityEngine.InputSystem;

[RequireComponent(typeof(NavMeshAgent))]    // なければ自動で追加
[RequireComponent(typeof(CapsuleCollider))] // なければ自動で追加

// クリックした場所へ移動する（NavMesh版）
public class OnMouseDownMoveNavMesh : MonoBehaviour
{
    private NavMeshAgent agent;

    void Start()
    {
        // NavMeshAgent を取得
        agent = GetComponent<NavMeshAgent>();
    }

    void Update()
    {
        // マウスやタッチでクリックされたら
        if (Pointer.current != null && Pointer.current.press.wasPressedThisFrame)
        {
            // 画面上の位置から Ray を飛ばす
            Vector2 screenPos = Pointer.current.position.ReadValue();
            Ray ray = Camera.main.ScreenPointToRay(screenPos);

            // Ray が地面に当たったら、その位置を目的地に設定
            if (Physics.Raycast(ray, out RaycastHit hit, 100f))
            {
                agent.destination = hit.point;
            }
        }
    }
}
