using UnityEngine;
using UnityEngine.SceneManagement;

// NavMeshAgent 同士が近づいたらシーンを切り換える
public class OnCollisionNavMeshSwitchScene : MonoBehaviour
{
    //-------------------------------------
    // 目標オブジェクト（この相手に近づいたら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に近づいたら反応）
    public string tagName = "";
    // 切り換えるシーン名（空なら次のシーンへ）
    public string sceneName = "";
    // 近づいたとみなす距離
    public float hitDistance = 0.7f;
    //-------------------------------------

    void Update()
    {
        GameObject other = null;

        // 目標オブジェクトが指定されていればそれを優先
        if (targetObject != null)
        {
            other = targetObject;
        }
        // 指定タグがあれば、そのタグを持つオブジェクトを探す
        else if (tagName != "")
        {
            other = GameObject.FindGameObjectWithTag(tagName);
        }

        // 目標との距離を測る
        float dist = Vector3.Distance(transform.position, other.transform.position);

        // 一定距離より近づいたらシーン切り換え
        if (dist < hitDistance)
        {
            if (sceneName != "")
            {
                // シーン名が指定されていれば、そのシーンへ
                SceneManager.LoadScene(sceneName);
            }
            else
            {
                // シーン名が空なら → ビルド設定の次のシーンへ
                int nextIndex = SceneManager.GetActiveScene().buildIndex + 1;

                if (nextIndex < SceneManager.sceneCountInBuildSettings)
                {
                    SceneManager.LoadScene(nextIndex);
                }
                else
                {
                    // 最後のシーンなら最初に戻る
                    SceneManager.LoadScene(0);
                }
            }
        }
    }
}
