﻿using UnityEngine;
using UnityEngine.AI;

[RequireComponent(typeof(NavMeshAgent))]   // なければ自動で追加
[RequireComponent(typeof(BoxCollider))]   // なければ自動で追加

// ずっと、追いかける（NavMesh版）
public class ForeverChaseNavMesh : MonoBehaviour
{
    //-------------------------------------
    // 追いかける目標オブジェクト
    public GameObject targetObject;
    // モデルの見た目を調整するための回転オフセット
    public Vector3 rotationOffset = new Vector3(0, 180, 0);
    //-------------------------------------
    private NavMeshAgent agent;

    void Start()
    {
        // NavMeshAgent を取得して、回転は自分で制御する設定にする
        agent = GetComponent<NavMeshAgent>();
        agent.updateRotation = false;
    }

    void Update()
    {
        if (targetObject != null)
        {
            // NavMeshAgent に目的地を指示
            agent.SetDestination(targetObject.transform.position);

            // 進行方向を計算（上下は無視）
            Vector3 direction = agent.desiredVelocity;
            direction.y = 0;
            if (direction.sqrMagnitude > 0.001f)
            {
                // 進行方向を向く＋回転オフセットを加える
                Quaternion lookRotation = Quaternion.LookRotation(direction) * Quaternion.Euler(rotationOffset);
                transform.rotation = Quaternion.Slerp(transform.rotation, lookRotation, Time.deltaTime * 10f);
            }
        }
    }
}
