library(rethinking)
data_in <-read.csv("f8-4.csv")
model <- ulam(
    alist(
        outcome ~ dnorm(mu, sigma),
        mu <- a[hospital] + b[hospital] * history,
        a[hospital] ~ dnorm(1, 0.1),
        b[hospital] ~ dnorm(0, 0.3),
        sigma ~ dexp(1)
        ) , data = data_in, chains=1)

precis( model , depth=2 )
traceplot(model)
