library(rethinking)
lotteries <- quap(
    alist(
        winning ~ dbinom(winning + losing, p), # 尤度
        p ~ dunif(0,1)                         # 事前分布（一様分布になっている）
    ) ,
    data=list(winning=4, losing=9))

# 二次近似の要約統計
precis(lotteries, digits = 5)
