cells = 14
グリッド <- seq(from=0, to=1, length.out=cells)
事前分布 <- rep(1, cells)
尤度 <- dbinom(4, size=13, prob=グリッド)
疑似正規化前の事後分布 <- 尤度 * 事前分布
疑似正規化後の事後分布 <- 疑似正規化前の事後分布 * (cells-1) / sum(疑似正規化前の事後分布) 
density.out = cbind(グリッド, 事前分布, 尤度, 疑似正規化前の事後分布, 疑似正規化後の事後分布)
write.csv(density.out, "f8-1.csv", row.names=FALSE)

# f8-1.csvはUTF-8コードで生成されますが、
# Excelに読み込みたい場合には、Shift-JISに変換してください
# UTF-8のまま読み込むと文字化けします
# ダウンロードファイルのf8-1.xlsxは、さらに指数表記の数値を通常の数値に変換し、
# Excel内で整形しています。
