library(rethinking)
d <- data.frame(read.csv("t7-2'.csv"))
d$Party <- as.factor(d$Party)
d$Party_id <- as.integer(d$Party)
str(d)
PartyModel <- quap(
    alist(
        Y ~ dnorm(mu, sigma),
        mu <- a[Party_id],
        a[Party_id] ~ dnorm(9.4, 3),
        sigma ~ dexp(1)
    ), 
    data = d)
labels <- paste("a[", 1:3, "]:", levels(d$Party), sep="")
plot(precis(PartyModel, depth=2, pars="a"),
     labels=labels,
     xlab="予想される評価")
precis(PartyModel, depth=2, pars="a")
