library(rethinking)
responses <- read.csv("t7-2.csv")
str(responses)
PoliSciModel <- quap(
    alist(
        Y ~ dnorm(mu, sigma),
        mu <- a + (b * X),
        a ~ dnorm(1, .2),
        b ~ dnorm(-.3, .2),
        sigma ~ dunif(0, 10)
    ), 
    data = responses)
precis(PoliSciModel)
