library(rethinking)

CarDataFrame <- read.csv("l6-2.csv")
CarDataFrame$Speed <- standardize(CarDataFrame$速度)
CarDataFrame$Weight <- standardize(CarDataFrame$重量)
CarDataFrame$Fueleco <- standardize(CarDataFrame$燃費)
regmodel <- quap(
    alist(
        Fueleco ~ dnorm(mu, sigma),
        mu <- a + (Speed_beta * Speed) + (Weight_beta * Weight),
        a ~ dnorm(0, 1),
        Weight_beta ~ dnorm (0, 1),
        Speed_beta ~ dnorm (0, 1),
        sigma ~ dexp(1)
    ), 
    data = CarDataFrame)
precis(regmodel, digits=6)
Car_lm <- lm (CarDataFrame$Fueleco ~ CarDataFrame$Speed + CarDataFrame$Weight)
summary(Car_lm)
