library(rethinking)
adult.weight <- read.csv("l6-1.csv")
sample.mean.wt <- mean(adult.weight$体重)
ldl.model <- quap(
    alist(
        LDL ~ dnorm(mu , st.dev.wt),
        mu <- alpha + beta * (adult.weight$体重 - sample.mean.wt),
        alpha ~ dnorm(130, 20),
        beta ~ dnorm(0, 1),
        st.dev.wt ~ dunif(0, 50)
    ), 
    data = adult.weight)
precis(ldl.model)

