library(tibble)

# グリッドの分位数を設定
grid_qs <- seq(0, 1, by = 0.01)
grid_qs
# グリッドの各分位数の事前分布を計算
prior <- dbeta(grid_qs, shape1 = 10, shape2 = 7)
prior
sum(prior)
# グリッドの各分位数の尤度を計算
likely <- dbinom(x = 5, size = 9, prob = grid_qs)
likely
# 両者を乗算して事後分布を計算
raw_post_1 <- prior * likely
raw_post_1
# raw_post_1の総和が100ではなく20.57881になっている
sum(raw_post_1)
# 総和が100になるようにraw_post_1を擬似正規化する
post_1 <- raw_post_1 * (length(grid_qs)-1) / sum(raw_post_1)
post_1
sum(post_1)

# dbetaの引数操作で事後分布を計算
post_2 <- dbeta(grid_qs, shape1 = 10 + 5, shape2 = 7 + 9 - 5)
post_2
sum(post_2)

# ここまでのすべての値でtibbleの表を作る
grid_data <- tibble(grid = grid_qs, prior, likely, raw_post_1, post_1, post_2)
save <- options(pillar.sigfig = 6)
print(grid_data, n=101)
options(save)
