library(tibble)

# グリッドの分位数を設定
分位数 <- seq(0, 1, by = 0.25)
分位数
# グリッドの各分位数の事前分布を計算
事前分布 <- dbeta(分位数, 31, 27)
事前分布
# グリッドの各分位数の尤度を計算
尤度 <- dbinom(8, 20, prob = 分位数)
尤度
# 両者を乗算して事後確率を計算
未加工の事後分布_1 <- 事前分布 * 尤度
未加工の事後分布_1
# 未加工の事後分布_1の総和は1.00ではなく0.632になっている
sum(未加工の事後分布_1)
# 総和が1.00になるように未加工の事後分布_1を正規化する
正規化後の事後分布_1 <- 未加工の事後分布_1 / sum(未加工の事後分布_1)
正規化後の事後分布_1
sum(正規化後の事後分布_1)
# ここまでのすべての値でデータフレームを作る
grid_app_df <- data.frame(分位数, 事前分布, 尤度,
  未加工の事後分布_1, 正規化後の事後分布_1)
grid_app_df
# ここまでのすべての値でtibbleの表を作る
grid_data <- tibble(分位数 = 分位数,
  事前分布 = 事前分布,
  尤度 = 尤度,
  `事前分布×尤度` = 未加工の事後分布_1,
  事後分布 = 正規化後の事後分布_1)
grid_data
