# 原著p.23
# RGuiの「ファイル」メニューで「スクリプトを開く」を選び
# ダウンロードファイルが格納されているディレクトリに移動した上で
# l2-3-1.rを選ぶとスクリプトウィンドウにこの内容が表示されます
# スクリプトウィンドウが前面にある状態で「編集」メニューの「全て実行」を選ぶと
# スクリプト全体が実行されます

successes = seq(0, 10, by=1)
successes
probabilities = dbinom(successes, size=10, .5)
probabilities
# cbind()を使うと、successesとdbinomの出力を横に並べた形で結合できます
# コメント記号の行頭の#を外して出力がどのように変わるかを見てみてください
#probabilities = cbind(successes, dbinom(successes, size=10, .5))
#probabilities

# 実行結果を.csvファイルとして出力したい場合はgetwd()の出力を見て、
# そのディレクトリ（フォルダ）に書き込んでよいかどうかを確認してください
# 別のディレクトリに出力したい場合は、setwd("")の""の間にディレクトリ名を指定し
#（getwd()の出力と同様に、ディレクトリ区切りは\ではなく/でなければなりません）
# よければ下のsetwd()行のコメント記号も取り除いて
# （もちろんあなたの環境に合わせてディレクトリ名を変えて）
# 実行してみてください

getwd()
#setwd("C:/Users/Smith/Documents")
write.csv(probabilities, "l2-1.csv")

# write.csvにrow.names=FALSEを与えると、行名である行番号が出力されなくなります
# 行番号はsuccessesよりも1ずつ大きい数になるので
# cbindでdbinomの出力の前にsuccessの列を挿入し
# 行番号を非表示にするのがオススメです
# そうしたい場合は、下の行の先頭の#を削除してください
#write.csv(probabilities, "l2-1.csv", row.names=FALSE)

