import pygame as pg
import random, player, enemy

class GameManager(): #【ゲーム管理】
    def __init__(self):
        # プロパティ：どんなデータを持つのか？
        self._player = player.Player()
        self._enemies = []
        self._effects = []
        self._factory = enemy.EnemyFactory()
        self.reset()

    @property
    def is_playing(self):
        return self._is_playing
    @property
    def is_cleared(self):
        return self._is_cleared

    # メソッド：どんな処理をするのか？
    def reset(self): # ゲームのリセット
        self._is_playing = True
        self._is_cleared = False
        self._player.reset()
        self._enemies.clear()
        self._spawn_count = 0

    def update(self): # 更新処理
        for e in self._effects:
            e.update()
        self._player.update()
        self._spawn_count += 1
        if self._spawn_count > 15: # 敵発生量
            self._spawn_count = 0
            self._enemies.append(self._factory.random_create())
        for e in self._enemies:
            if e.is_alive == False:
                self._enemies.remove(e)
                break
            e.update()
            # 敵が下に落ちたら消える
            if e.rect.y >= 650:
                self._enemies.remove(e)
            # 敵と主人公が衝突したらダメージ
            if e.rect.colliderect(self._player.rect):
                self._enemies.remove(e)
                self._player.damage()
                self._player.hp -= 50
                if self._player.hp <= 0:
                    self._is_playing = False

    def draw(self, screen): # 描画処理
        for e in self._effects:
            e.draw(screen)
        self._player.draw(screen)
        for e in self._enemies:
            e.draw(screen)
