//
//  ViewController.swift
//  AItestApp
//
//  Created by 森 巧尚 on 2017/11/01.
//  Copyright © 2017年 myname. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UINavigationControllerDelegate, UIImagePickerControllerDelegate {
    @IBOutlet weak var myImageView: UIImageView!
    @IBOutlet weak var myTextView: UITextView!

    // カメラロールを表示するimagePicker
    var imagePicker: UIImagePickerController!

    override func viewDidLoad() {
        super.viewDidLoad()
        // imagePickerと、テキストビューを初期化
        imagePicker = UIImagePickerController()
        imagePicker.delegate = self
        myTextView.text = ""
    }
    
    @IBAction func tapButton(_ sender: Any) {
        // カメラロールを表示する
        imagePicker.sourceType = .photoLibrary
        present(imagePicker, animated: true, completion: nil)
    }
    
    // カメラロールで処理が終わったときに呼び出される
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [String : Any]) {
        // カメラロールを閉じて
        imagePicker.dismiss(animated: true, completion: nil)
        // 選択した画像が存在すれば
        guard let image = info[UIImagePickerControllerOriginalImage] as? UIImage else {
            return
        }
        // イメージビューの表示する
        myImageView.image = image
    }

    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

