package jp.study.chatapplication;

import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognizerIntent;
import android.support.v7.app.AppCompatActivity;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Calendar;
public class ChatActivity extends AppCompatActivity implements View.OnClickListener {
    private EditText mInputMessage;
    private Button mSendMessage;
    private LinearLayout mMessageLog;
    private TextView mCpuMessage;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_chat);
        // XMLのViewを取得します
        mInputMessage = (EditText) findViewById(R.id.input_message); //ユーザが入力するフィールド
        mSendMessage = (Button) findViewById(R.id.send_message); // SENDボタン
        mMessageLog = (LinearLayout) findViewById(R.id.message_log);//入力履歴を表示するレイアウト
        mCpuMessage = (TextView) findViewById(R.id.cpu_message); // コンピューターからの応答
        mSendMessage.setOnClickListener(this); // ボタンが押された時にメソッドを実行させる
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_chat, menu);
        if (getPackageManager().queryIntentActivities(new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH), 0).size() == 0) {
            menu.removeItem(R.id.action_voice_input);
        }
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        //noinspection SimplifiableIfStatement
        if (id == R.id.action_voice_input) {
            Intent intent = new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH);
            //intent.putExtra( RecognizerIntent.EXTRA_LANGUAGE_MODEL, RecognizerIntent.LANGUAGE_MODEL_FREE_FORM);
            //intent.putExtra( RecognizerIntent.EXTRA_PROMPT, "VoiceRecognitionTest");
            // インテント発行
            startActivityForResult(intent, 0);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onClick(View v) {
        if (v.equals(mSendMessage)) {
            send();
        }
    }

    private void send() {
        // SENDボタンが押された時の処理
        String inputText = mInputMessage.getText().toString();
        String lowerInputText = inputText.toLowerCase();
        String answer;
        TextView userMessage = new TextView(this); // 新しいTextViewを作る
        final int messageColor = getResources().getColor(R.color.message_color);
        userMessage.setTextColor(messageColor);
        userMessage.setBackgroundResource(R.drawable.user_message);
        userMessage.setText(inputText); // TextViewに入力したテクストをセットする
        // コメントサイズに合わせる
        LinearLayout.LayoutParams userMessageLayout = new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        userMessageLayout.gravity = Gravity.END;
        // 端末によって最適な隙間をつける
        final int marginSize = getResources().getDimensionPixelSize(R.dimen.message_margin);
        // 隙間を設定する
        userMessageLayout.setMargins(0, marginSize, 0, marginSize);
        mMessageLog.addView(userMessage, 0, userMessageLayout); // TextViewをViewの一番上にセット
        if (lowerInputText.contains(getString(R.string.how_are_you))) {
            answer = getString(R.string.fine);
        } else if (lowerInputText.contains(getString(R.string.tire))) {
            answer = getString(R.string.bless_you);
        } else if (lowerInputText.contains(getString(R.string.fortune))) {
            double random = Math.random() * 5.1d;
            if (random < 1d) {
                answer = getString(R.string.worst_luck);
            } else if (random < 2d) {
                answer = getString(R.string.bad_luck);
            } else if (random < 3d) {
                answer = getString(R.string.good_luck);
            } else if (random < 4d) {
                answer = getString(R.string.nice_luck);
            } else if (random < 5d) {
                answer = getString(R.string.best_luck);
            } else {
                answer = getString(R.string.amazing_best_luck);
            }
        } else if (lowerInputText.contains(getString(R.string.time))) {
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(Calendar.HOUR); // 時
            int minute = cal.get(Calendar.MINUTE); // 分
            int second = cal.get(Calendar.SECOND); // 秒
            answer = getString(R.string.time_format, hour, minute, second);
        } else {
            answer = getString(R.string.good);
        }
        final TextView cpuMessage = new TextView(this); // 内部クラスから参照するためfinalで宣言
        cpuMessage.setTextColor(messageColor);
        cpuMessage.setBackgroundResource(R.drawable.cpu_message);
        cpuMessage.setText(answer);
        cpuMessage.setGravity(Gravity.START);
        mInputMessage.setText("");
        TranslateAnimation userMessageAnimation = new TranslateAnimation(mMessageLog.
                getWidth(), 0, 0, 0);
        userMessageAnimation.setDuration(1000);
        userMessageAnimation.setAnimationListener(new Animation.AnimationListener() {
            //クラス名が宣言されていない内部クラスを無名内部クラスといいます。
            @Override
            public void onAnimationStart(Animation animation) {
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                // コメントサイズに合わせる
                LinearLayout.LayoutParams cpuMessageLayout = new LinearLayout.LayoutParams(
                        LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.
                        WRAP_CONTENT);
                cpuMessageLayout.gravity = Gravity.START;
                // 隙間を設定する
                cpuMessageLayout.setMargins(marginSize, marginSize, marginSize, marginSize);
                mMessageLog.addView(cpuMessage, 0, cpuMessageLayout);
                TranslateAnimation cpuAnimation = new TranslateAnimation(-mMessageLog.
                        getWidth(), 0, 0, 0);
                cpuAnimation.setDuration(1000);
                cpuMessage.setAnimation(cpuAnimation);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
            }
        });
        userMessage.startAnimation(userMessageAnimation);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0 && resultCode == RESULT_OK && data.hasExtra(RecognizerIntent.
                EXTRA_RESULTS)) {
            ArrayList<String> results = data.getStringArrayListExtra(RecognizerIntent.
                    EXTRA_RESULTS);
            if (results.size() > 0) {
                mInputMessage.setText(results.get(0));
                send();
            }
        }
    }
}