package jp.study.debugapplication;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;

public class DebugActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_debug);
        TextView textView = (TextView) findViewById(R.id.text);
        String result;
        try {
            result = exceptionTest(50, 0);
        } catch (java.lang.ArithmeticException ex) {
            result = "onCreate()でエラーをキャッチしました" + ex.getMessage();
        } catch (java.lang.IllegalArgumentException ex) {
            result = "不正な引数を渡しました" + ex.getMessage();
        }
        textView.setText(result);
    }

    private String exceptionTest(int x, int y) {
        if (x >= 100) {
            throw new IllegalArgumentException("100以上の値を割ることはできません");
        }
        try {
            return String.valueOf(x / y);
        } catch (java.lang.ArithmeticException ex) {
            throw new java.lang.IllegalArgumentException("IllegalArgumentExceptionに置き換え");
        } finally {
            Log.d("exceptionTest", "x = " + String.valueOf(x) + ", y = " + String.valueOf(y));
        }
    }

    private int calc(int x) {
        int result = 0;
        for (int i = 1; i <= x; i++) {
            result += i;
            Log.d("result", String.valueOf(i) + ":" + String.valueOf(result));
        }
        return result;

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_debug, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
