package jp.study.chatapplication;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.util.Calendar;

public class ChatActivity extends AppCompatActivity implements View.OnClickListener {
    private EditText mInputMessage;
    private Button mSendMessage;
    private LinearLayout mMessageLog;
    private TextView mCpuMessage;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_chat);
        mInputMessage = (EditText) findViewById(R.id.input_message);
        mSendMessage = (Button) findViewById(R.id.send_message);
        mMessageLog = (LinearLayout) findViewById(R.id.message_log);
        mCpuMessage = (TextView) findViewById(R.id.cpu_message);
        mSendMessage.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        if (v.equals(mSendMessage)) {
            // SENDボタンが押された時の処理
            String inputText = mInputMessage.getText().toString();
            String answer;
            TextView userMessage = new TextView(this); // 新しいTextViewを作る
            userMessage.setText(inputText); // TextViewに入力したテキストをセットする
            userMessage.setGravity(Gravity.END); // 右寄せ
            mMessageLog.addView(userMessage, 0); // TextViewをViewの一番上にセット
            if (inputText.contains("元気ですか")) {
                answer = "元気です";
            } else if (inputText.contains("疲れた")) {
                answer = "おつかれさまです";
            } else if (inputText.contains("おみくじ")) {
                double random = Math.random() * 5.1d;
                if (random < 1d) {
                    answer = "大凶";
                } else if (random < 2d) {
                    answer = "凶";
                } else if (random < 3d) {
                    answer = "吉";
                } else if (random < 4d) {
                    answer = "中吉";
                } else if (random < 5d) {
                    answer = "大吉";
                } else {
                    answer = "超大吉";
                }
            } else if (inputText.contains("時間")) {
                Calendar cal = Calendar.getInstance();
                int hour = cal.get(Calendar.HOUR); // 時
                int minute = cal.get(Calendar.MINUTE); // 分
                int second = cal.get(Calendar.SECOND); // 秒
                answer = String.format("ただいまの時間は%1$d時%2$d分%3$d秒です", hour, minute, second);
            } else {
                answer = "それはいいですね";
            }
            TextView cpuMessage = new TextView(this);
            cpuMessage.setText(answer);
            cpuMessage.setGravity(Gravity.START);
            mMessageLog.addView(cpuMessage, 0);
            mInputMessage.setText("");
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_chat, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}

