﻿
namespace XELF.Framework {

	/// <summary>
	/// 2Dベクトル
	/// </summary>
	public partial struct Vector2 {
		/// <summary>
		/// X
		/// </summary>
		public float X;
		/// <summary>
		/// Y
		/// </summary>
		public float Y;
	}

	/// <summary>
	/// 3Dベクトル
	/// </summary>
	public partial struct Vector3 {
		/// <summary>
		/// X
		/// </summary>
		public float X;
		/// <summary>
		/// Y
		/// </summary>
		public float Y;
		/// <summary>
		/// Z
		/// </summary>
		public float Z;
	}

	/// <summary>
	/// 4Dベクトル
	/// </summary>
	public partial struct Vector4 {
		/// <summary>
		/// X
		/// </summary>
		public float X;
		/// <summary>
		/// Y
		/// </summary>
		public float Y;
		/// <summary>
		/// Z
		/// </summary>
		public float Z;
		/// <summary>
		/// W
		/// </summary>
		public float W;
	}

}


namespace XELF.Framework {

	public partial struct Vector2 {
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="x">X</param>
		/// <param name="y">Y</param>
		public Vector2(float x, float y) {
			X = x;
			Y = y;
		}
	}

	public partial struct Vector3 {
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="x">X</param>
		/// <param name="y">Y</param>
		/// <param name="z">Z</param>
		public Vector3(float x, float y, float z) {
			X = x;
			Y = y;
			Z = z;
		}
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="value"></param>
		/// <param name="z"></param>
		public Vector3(Vector2 value, float z) {
			X = value.X;
			Y = value.Y;
			Z = z;
		}
	}

	public partial struct Vector3 {
		static Vector3 zero = new Vector3(0, 0, 0);
		static Vector3 one = new Vector3(1, 1, 1);
		static Vector3 unitX = new Vector3(1, 0, 0);
		static Vector3 unitY = new Vector3(0, 1, 0);
		static Vector3 unitZ = new Vector3(0, 0, 1);

		/// <summary>0ベクトル</summary>
		public static Vector3 Zero { get { return zero; } }
		/// <summary>すべての要素が1のベクトル</summary>
		public static Vector3 One { get { return one; } }
		/// <summary>X軸単位ベクトル</summary>
		public static Vector3 UnitX { get { return unitX; } }
		/// <summary>Y軸単位ベクトル</summary>
		public static Vector3 UnitY { get { return unitY; } }
		/// <summary>Z軸単位ベクトル</summary>
		public static Vector3 UnitZ { get { return unitZ; } }

		/// <summary>
		/// 等しいか
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns>同じときにtrue</returns>
		public static bool operator ==(Vector3 a, Vector3 b) {
			return a.X == b.X && a.Y == b.Y && a.Z == b.Z;
		}
		/// <summary>
		/// 等しくないか
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns>同じでないときにtrue</returns>
		public static bool operator !=(Vector3 a, Vector3 b) {
			return a.X != b.X && a.Y != b.Y && a.Z != b.Z;
		}
		/// <summary>
		/// 等しいか
		/// </summary>
		/// <param name="o"></param>
		/// <returns>同じときにtrue</returns>
		public override bool Equals(object o) {
			if (!(o is Vector3)) return false;
			var b = (Vector3)o;
			return X == b.X && Y == b.Y && Z == b.Z;
		}
		/// <summary>
		/// ハッシュコードを取得します。
		/// </summary>
		/// <returns></returns>
		public override int GetHashCode() {
			return base.GetHashCode();
		}
	}

	public partial struct Vector4 {
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="x">X</param>
		/// <param name="y">Y</param>
		/// <param name="z">Z</param>
		/// <param name="w">W</param>
		public Vector4(float x, float y, float z, float w) {
			X = x;
			Y = y;
			Z = z;
			W = w;
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="value"></param>
		/// <param name="w"></param>
		public Vector4(Vector3 value, float w) {
			X = value.X;
			Y = value.Y;
			Z = value.Z;
			W = w;
		}

	}

}
