﻿
namespace XELF.Framework {

	public partial struct Vector2 {
		/// <summary>
		/// ベクトルのスカラー倍。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="scale">スカラー</param>
		/// <returns>結果</returns>
		public static Vector2 operator *(Vector2 a, float scale) {
			return new Vector2(a.X * scale, a.Y * scale);
		}
		/// <summary>
		/// ベクトルのスカラー倍。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="scale">スカラー</param>
		/// <returns>結果</returns>
		public static Vector2 operator *(float scale, Vector2 a) {
			return new Vector2(a.X * scale, a.Y * scale);
		}
	}

	public partial struct Vector3 {
		/// <summary>
		/// ベクトルのスカラー倍。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="scale">スカラー</param>
		/// <returns>結果</returns>
		public static Vector3 operator *(Vector3 a, float scale) {
			return new Vector3(a.X * scale, a.Y * scale, a.Z * scale);
		}
		/// <summary>
		/// ベクトルのスカラー倍。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="scale">スカラー</param>
		/// <returns>結果</returns>
		public static Vector3 operator *(float scale, Vector3 a) {
			return new Vector3(a.X * scale, a.Y * scale, a.Z * scale);
		}
	}

	public partial struct Vector4 {
		/// <summary>
		/// ベクトルのスカラー倍。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="scale">スカラー</param>
		/// <returns>結果</returns>
		public static Vector4 operator *(Vector4 a, float scale) {
			return new Vector4(a.X * scale, a.Y * scale, a.Z * scale, a.W * scale);
		}
		/// <summary>
		/// ベクトルのスカラー倍。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="scale">スカラー</param>
		/// <returns>結果</returns>
		public static Vector4 operator *(float scale, Vector4 a) {
			return new Vector4(a.X * scale, a.Y * scale, a.Z * scale, a.W * scale);
		}
	}

}
