﻿
namespace XELF.Framework {

	public partial struct Vector3 {
		/// <summary>
		/// スカラー三重積（平行六面体の符号付き体積）
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="c"></param>
		/// <returns></returns>
		public static float ScalarTripleProduct(ref Vector3 a, ref Vector3 b, ref Vector3 c) {
			return
				(a.Y * b.Z - a.Z * b.Y) * c.X +
				(a.Z * b.X - a.X * b.Z) * c.Y +
				(a.X * b.Y - a.Y * b.X) * c.Z;
		}
	}

}

