﻿
namespace XELF.Framework {

	public partial struct Vector2 {
		/// <summary>
		/// 正規化する。
		/// </summary>
		public void Normalize() {
			var r = ReciprocalLength();
			X *= r;
			Y *= r;
		}
		/// <summary>
		/// 正規化する。
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static Vector2 Normalize(Vector2 value) {
			var r = value.ReciprocalLength();
			return new Vector2(value.X * r, value.Y * r);
		}
	}

	public partial struct Vector3 {
		/// <summary>
		/// 正規化する。
		/// </summary>
		public void Normalize() {
			var r = ReciprocalLength();
			X *= r;
			Y *= r;
			Z *= r;
		}
		/// <summary>
		/// 正規化する。
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static Vector3 Normalize(Vector3 value) {
			var r = value.ReciprocalLength();
			return new Vector3(value.X * r, value.Y * r, value.Z * r);
		}
	}

	public partial struct Vector4 {
		/// <summary>
		/// 正規化する。
		/// </summary>
		public void Normalize() {
			var r = ReciprocalLength();
			X *= r;
			Y *= r;
			Z *= r;
			W *= r;
		}
		/// <summary>
		/// 正規化する。
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static Vector4 Normalize(Vector4 value) {
			var r = value.ReciprocalLength();
			return new Vector4(value.X * r, value.Y * r, value.Z * r, value.W * r);
		}
	}

}
