﻿
namespace XELF.Framework {

	public partial struct Vector2 {
		/// <summary>
		/// 符号反転
		/// </summary>
		public void Negate() {
			X = -X;
			Y = -Y;
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static void Negate(ref Vector2 value, ref Vector2 result) {
			result = new Vector2(-value.X, -value.Y);
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static Vector2 Negate(ref Vector2 value) {
			return new Vector2(-value.X, -value.Y);
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static Vector2 operator -(Vector2 value) {
			return new Vector2(-value.X, -value.Y);
		}
	}

	public partial struct Vector3 {
		/// <summary>
		/// 符号反転
		/// </summary>
		public void Negate() {
			X = -X;
			Y = -Y;
			Z = -Z;
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static void Negate(ref Vector3 value, ref Vector3 result) {
			result = new Vector3(-value.X, -value.Y, -value.Z);
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static Vector3 Negate(ref Vector4 value) {
			return new Vector3(-value.X, -value.Y, -value.Z);
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static Vector3 operator -(Vector3 value) {
			return new Vector3(-value.X, -value.Y, -value.Z);
		}
	}

	public partial struct Vector4 {
		/// <summary>
		/// 符号反転
		/// </summary>
		public void Negate() {
			X = -X;
			Y = -Y;
			Z = -Z;
			W = -W;
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static void Negate(ref Vector4 value, ref Vector4 result) {
			result = new Vector4(-value.X, -value.Y, -value.Z, -value.W);
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static Vector4 Negate(ref Vector4 value) {
			return new Vector4(-value.X, -value.Y, -value.Z, -value.W);
		}
		/// <summary>
		/// 符号反転
		/// </summary>
		public static Vector4 operator -(Vector4 value) {
			return new Vector4(-value.X, -value.Y, -value.Z, -value.W);
		}
	}

}
