﻿
namespace XELF.Framework {

	public partial struct Vector2 {
		/// <summary>
		/// 長さ
		/// </summary>
		public float Length() {
			var value = LengthSquared();
			return MathHelper.Rsqrt(value) * value;
		}
		/// <summary>
		/// 長さの2乗
		/// </summary>
		public float LengthSquared() {
			return X * X + Y * Y;
		}
		/// <summary>
		/// 長さの逆数
		/// </summary>
		/// <returns></returns>
		public float ReciprocalLength() {
			return MathHelper.Rsqrt(LengthSquared());
		}
	}

	public partial struct Vector3 {
		/// <summary>
		/// 長さ
		/// </summary>
		public float Length() {
			var value = LengthSquared();
			return MathHelper.Rsqrt(value) * value;
		}
		/// <summary>
		/// 長さの2乗
		/// </summary>
		public float LengthSquared() {
			return X * X + Y * Y + Z * Z;
		}
		/// <summary>
		/// 長さの逆数
		/// </summary>
		/// <returns></returns>
		public float ReciprocalLength() {
			return MathHelper.Rsqrt(LengthSquared());
		}
	}

	public partial struct Vector4 {
		/// <summary>
		/// 長さ
		/// </summary>
		public float Length() {
			var value = LengthSquared();
			return MathHelper.Rsqrt(value) * value;
		}
		/// <summary>
		/// 長さの2乗
		/// </summary>
		public float LengthSquared() {
			return X * X + Y * Y + Z * Z + W * W;
		}
		/// <summary>
		/// 長さの逆数
		/// </summary>
		/// <returns></returns>
		public float ReciprocalLength() {
			return MathHelper.Rsqrt(LengthSquared());
		}
	}

}
