﻿
namespace XELF.Framework {

	public partial struct Vector2 {
		/// <summary>
		/// 内積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static float Dot(Vector2 a, Vector2 b) {
			float result;
			Dot(ref a, ref b, out result);
			return result;
		}
		/// <summary>
		/// 内積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Dot(ref Vector2 a, ref Vector2 b, out float result) {
			result = a.X * b.X + a.Y * b.Y;
		}
	}

	public partial struct Vector3 {
		/// <summary>
		/// 内積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static float Dot(Vector3 a, Vector3 b) {
			float result;
			Dot(ref a, ref b, out result);
			return result;
		}
		/// <summary>
		/// 内積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Dot(ref Vector3 a, ref Vector3 b, out float result) {
			result = a.X * b.X + a.Y * b.Y + a.Z * b.Z;
		}
	}

	public partial struct Vector4 {
		/// <summary>
		/// 内積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static float Dot(Vector4 a, Vector4 b) {
			float result;
			Dot(ref a, ref b, out result);
			return result;
		}
		/// <summary>
		/// 内積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Dot(ref Vector4 a, ref Vector4 b, out float result) {
			result = a.X * b.X + a.Y * b.Y + a.Z * b.Z + a.W * b.W;
		}
	}

}
