﻿
namespace XELF.Framework {

	public partial struct Vector3 {
		/// <summary>
		/// 外積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Cross(ref Vector3 a, ref Vector3 b, out Vector3 result) {
			result = new Vector3();
			result.X = a.Y * b.Z - a.Z * b.Y;
			result.Y = a.Z * b.X - a.X * b.Z;
			result.Z = a.X * b.Y - a.Y * b.X;
		}
		/// <summary>
		/// 外積
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static Vector3 Cross(Vector3 a, Vector3 b) {
			Vector3 result;
			Cross(ref a, ref b, out result);
			return result;
		}
	}

}
