﻿
namespace XELF.Framework {

	public partial struct Vector3 {

		/// <summary>
		/// Catmull-Rom
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="c"></param>
		/// <param name="d"></param>
		/// <param name="amount"></param>
		/// <param name="result"></param>
		public static void CatmullRom(ref Vector3 a, ref Vector3 b, ref Vector3 c, ref Vector3 d,
			float amount, out Vector3 result) {
			Vector3 q0, q1, q2, q3;

			float t0 = ((2 - amount) * amount - 1) * amount * 0.5f;
			float t1 = (((3 * amount - 5) * amount) * amount + 2) * 0.5f;
			float t2 = ((4 - 3 * amount) * amount + 1) * amount * 0.5f;
			float t3 = ((amount - 1) * amount * amount) * 0.5f;

			Multiply(ref a, t0, out q0);
			Multiply(ref b, t1, out q1);
			Multiply(ref c, t2, out q2);
			Multiply(ref d, t3, out q3);
			Add(ref q0, ref q1, out q0);
			Add(ref q2, ref q3, out q2);
			Add(ref q0, ref q2, out result);
		}
	}

}
