﻿
namespace XELF.Framework {

	public partial struct Vector2 {
		/// <summary>
		/// 2つのベクトルの和。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="b">元のベクトル</param>
		/// <returns>和</returns>
		public static Vector2 operator +(Vector2 a, Vector2 b) {
			return new Vector2(a.X + b.X, a.Y + b.Y);
		}
		/// <summary>
		/// 2つのベクトルの差。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="b">元のベクトル</param>
		/// <returns>差</returns>
		public static Vector2 operator -(Vector2 a, Vector2 b) {
			return new Vector2(a.X - b.X, a.Y - b.Y);
		}
	}

	public partial struct Vector3 {
		/// <summary>
		/// 加算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Add(ref Vector3 a, ref Vector3 b, out Vector3 result) {
			result = new Vector3(a.X + b.X, a.Y + b.Y, a.Z + b.Z);
		}
		/// <summary>
		/// 減算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Subtract(ref Vector3 a, ref Vector3 b, out Vector3 result) {
			result = new Vector3(a.X - b.X, a.Y - b.Y, a.Z - b.Z);
		}

		/// <summary>
		/// 2つのベクトルの和。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="b">元のベクトル</param>
		/// <returns>和</returns>
		public static Vector3 operator +(Vector3 a, Vector3 b) {
			return new Vector3(a.X + b.X, a.Y + b.Y, a.Z + b.Z);
		}
		/// <summary>
		/// 2つのベクトルの差。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="b">元のベクトル</param>
		/// <returns>差</returns>
		public static Vector3 operator -(Vector3 a, Vector3 b) {
			return new Vector3(a.X - b.X, a.Y - b.Y, a.Z - b.Z);
		}
	}

	public partial struct Vector4 {
		/// <summary>
		/// 2つのベクトルの和。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="b">元のベクトル</param>
		/// <returns>和</returns>
		public static Vector4 operator +(Vector4 a, Vector4 b) {
			return new Vector4(a.X + b.X, a.Y + b.Y, a.Z + b.Z, a.W + b.W);
		}
		/// <summary>
		/// 2つのベクトルの差。
		/// </summary>
		/// <param name="a">元のベクトル</param>
		/// <param name="b">元のベクトル</param>
		/// <returns>差</returns>
		public static Vector4 operator -(Vector4 a, Vector4 b) {
			return new Vector4(a.X - b.X, a.Y - b.Y, a.Z - b.Z, a.W - b.W);
		}
	}

}
