﻿
namespace XELF.Framework {

	public partial struct Quaternion {

		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="a">元のクォータニオン</param>
		/// <param name="scale">スカラー</param>
		/// <param name="result">結果</param>
		public static void Multiply(ref Quaternion a, float scale, out Quaternion result) {
			result.X = a.X * scale;
			result.Y = a.Y * scale;
			result.Z = a.Z * scale;
			result.W = a.W * scale;
		}

		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="scale">スカラー</param>
		/// <param name="a">元のクォータニオン</param>
		/// <param name="result">結果</param>
		public static void Multiply(float scale, ref Quaternion a, out Quaternion result) {
			result.X = a.X * scale;
			result.Y = a.Y * scale;
			result.Z = a.Z * scale;
			result.W = a.W * scale;
		}

		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="scale">スカラー</param>
		/// <param name="a">元のクォータニオン</param>
		/// <returns>結果</returns>
		public static Quaternion operator *(float scale, Quaternion a) {
			Quaternion result;
			Multiply(scale, ref a, out result);
			return result;
		}

		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="a">元のクォータニオン</param>
		/// <param name="scale">スカラー</param>
		/// <returns>結果</returns>
		public static Quaternion operator *(Quaternion a, float scale) {
			Quaternion result;
			Multiply(ref a, scale, out result);
			return result;
		}

	}

}
