﻿
namespace XELF.Framework {

	public partial struct Quaternion {
		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="a">A</param>
		/// <param name="b">B</param>
		/// <param name="result">結果</param>
		public static void Multiply(ref Quaternion a, ref Quaternion b, out Quaternion result) {
			result = new Quaternion();
			result.X = a.W * b.X + a.X * b.W + a.Y * b.Z - a.Z * b.Y;
			result.Y = a.W * b.Y + a.Y * b.W - a.X * b.Z + a.Z * b.X;
			result.Z = a.W * b.Z + a.Z * b.W + a.X * b.Y - a.Y * b.X;
			result.W = a.W * b.W - a.X * b.X - a.Y * b.Y - a.Z * b.Z;
		}

		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns>結果</returns>
		public static Quaternion operator *(Quaternion a, Quaternion b) {
			Quaternion result;
			Multiply(ref a, ref b, out result);
			return result;
		}
	}

}
