﻿
namespace XELF.Framework {

	public partial struct Quaternion {
		/// <summary>
		/// 線形補間
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="amount"></param>
		/// <param name="result"></param>
		public static void Lerp(ref Quaternion a, ref Quaternion b, float amount, out Quaternion result) {
			Quaternion q0, q1;
			float s = 1 - amount;
			Multiply(ref a , s, out q0);
			Multiply(ref b , amount, out q1);
			Add(ref q0, ref q1, out result);
		}

	}
}
