﻿
namespace XELF.Framework {

	public partial struct Quaternion {
		/// <summary>
		/// 長さ
		/// </summary>
		public float Length() {
			return (float)System.Math.Sqrt(LengthSquared());
		}
		/// <summary>
		/// 長さの2乗
		/// </summary>
		public float LengthSquared() {
			return X * X + Y * Y + Z * Z + W * W;
		}
		/// <summary>
		/// 長さの逆数
		/// </summary>
		/// <returns></returns>
		public float ReciprocalLength() {
			return MathHelper.Rsqrt(LengthSquared());
		}
	}

}
