﻿
namespace XELF.Framework {

	public partial struct Quaternion {
		/// <summary>
		/// 逆クォータニオン
		/// </summary>
		public static void Inverse(ref Quaternion value, out Quaternion result) {
			var r = MathHelper.Rcp(value.LengthSquared());
			result = new Quaternion(-value.X * r, -value.Y * r, -value.Z * r, value.W * r);
		}
		/// <summary>
		/// 逆クォータニオン
		/// </summary>
		public static Quaternion Inverse(Quaternion value) {
			Quaternion result;
			Inverse(ref value, out result);
			return result;
		}
	}

}
