using System;
#if XNA
using Microsoft.Xna.Framework;
using _MathHelper = Microsoft.Xna.Framework.MathHelper;
#else
using _MathHelper = XELF.Framework.MathHelper;
#endif

namespace XELF.Framework {
#if XNA
	public static partial class QuaternionHelper {
#else
	public partial struct Quaternion {
#endif

		/// <summary>
		/// ]O̕xNgƉ]̕xNg]NH[^jIB
		/// </summary>
		/// <param name="from">]O̕xNg</param>
		/// <param name="to">]̕xNg</param>
		/// <returns></returns>
		public static Quaternion CreateFromDirectionToDirection(Vector3 from, Vector3 to) {
			float d;
			Vector3.Dot(ref from, ref to, out d);
			Vector3 axis;
			Vector3.Cross(ref from, ref to, out axis);
			var qw = (float)Math.Sqrt(from.LengthSquared() * to.LengthSquared()) + d;
			Quaternion result;
			if (qw < 0.0001f) {
				result = new Quaternion(-from.Z, from.Y, from.X, 0);
			} else {
				result = new Quaternion(axis.X, axis.Y, axis.Z, qw);
			}
			result.Normalize();
			return result;
		}
#if DEBUG
		/// <summary>
		/// ]O̕xNgƉ]̕xNg]NH[^jIB
		/// </summary>
		/// <param name="from">]O̕xNg</param>
		/// <param name="to">]̕xNg</param>
		/// <returns></returns>
		public static Quaternion CreateFromDirectionToDirectionBasic(Vector3 from, Vector3 to) {
			Vector3 axis;
			float angle;
			Vector3.Cross(ref from, ref to, out axis);
			if (axis.LengthSquared() < 1e-6f)
				return new Quaternion(-from.Z, from.Y, from.X, 0);
			axis.Normalize();
			Vector3.Dot(ref from, ref to, out angle);
			angle = _MathHelper.Clamp(angle, -1, 1);
			angle = (float)Math.Acos(angle);
			if (angle < 1e-6f)
				return new Quaternion(axis, 0);
			Quaternion result;
			Quaternion.CreateFromAxisAngle(ref axis, angle, out result);
			return result;
		}
#endif
	}
}

