﻿
namespace XELF.Framework {

	public partial struct Quaternion {
		/// <summary>
		/// 軸周りの回転からクォータニオンを作る。
		/// </summary>
		/// <param name="axis">軸</param>
		/// <param name="angle">角度[Radian]</param>
		/// <param name="result">クォータニオン</param>
		public static void CreateFromAxisAngle(ref Vector3 axis, float angle, out Quaternion result) {
			Vector3 _axis = axis;
			_axis.Normalize();
			angle *= 0.5f;
			var s = (float)System.Math.Sin(angle);
			var c = (float)System.Math.Cos(angle);
			Vector3.Multiply(ref _axis, s, out _axis);
			result = new Quaternion(_axis, c);
		}
	}

}
