﻿#if XNA
using Microsoft.Xna.Framework;
#endif

namespace XELF.Framework {
#if XNA
	public static partial class QuaternionHelper {
#else
	public partial struct Quaternion {
#endif
		/// <summary>
		/// Catmull-Rom曲線の点を計算する。
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="c"></param>
		/// <param name="d"></param>
		/// <param name="amount"></param>
		/// <param name="result"></param>
		public static void CatmullRom(ref Quaternion a, ref Quaternion b, ref Quaternion c, ref Quaternion d,
			float amount, out Quaternion result) {
			Quaternion q0, q1, q2, q3;
			Log(ref a, out q0);
			Log(ref b, out q1);
			Log(ref c, out q2);
			Log(ref d, out q3);

			float t0 = ((2 - amount) * amount - 1) * amount * 0.5f;
			float t1 = (((3 * amount - 5) * amount) * amount + 2) * 0.5f;
			float t2 = ((4 - 3 * amount) * amount + 1) * amount * 0.5f;
			float t3 = ((amount - 1) * amount * amount) * 0.5f;

			Quaternion.Multiply(ref q0, t0, out q0);
			Quaternion.Multiply(ref q1, t1, out q1);
			Quaternion.Multiply(ref q2, t2, out q2);
			Quaternion.Multiply(ref q3, t3, out q3);
			Quaternion.Add(ref q0, ref q1, out q0);
			Quaternion.Add(ref q2, ref q3, out q2);
			Quaternion.Add(ref q0, ref q2, out q0);

			Exp(ref q0, out result);
		}
	}

}
