﻿
namespace XELF.Framework {

	public partial struct Quaternion {
		/// <summary>
		/// 加算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Add(ref Quaternion a, ref Quaternion b, out Quaternion result) {
			result.X = a.X + b.X;
			result.Y = a.Y + b.Y;
			result.Z = a.Z + b.Z;
			result.W = a.W + b.W;
		}

		/// <summary>
		/// 減算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Subtract(ref Quaternion a, ref Quaternion b, out Quaternion result) {
			result.X = a.X - b.X;
			result.Y = a.Y - b.Y;
			result.Z = a.Z - b.Z;
			result.W = a.W - b.W;
		}

		/// <summary>
		/// 加算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static Quaternion operator +(Quaternion a, Quaternion b) {
			Quaternion result;
			Add(ref a, ref b, out result);
			return result;
		}

		/// <summary>
		/// 減算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static Quaternion operator -(Quaternion a, Quaternion b) {
			Quaternion result;
			Subtract(ref a, ref b, out result);
			return result;
		}
	}

}
