﻿
namespace XELF.Framework {

	/// <summary>
	/// 平面
	/// </summary>
	public partial struct Plane {
		/// <summary>
		/// 法線
		/// </summary>
		public Vector3 Normal;
		/// <summary>
		/// 定数D
		/// </summary>
		public float D;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="c"></param>
		/// <param name="d"></param>
		public Plane(float a, float b, float c, float d) {
			Normal = new Vector3(a, b, c); D = d;
		}
	}

	public partial struct Plane {
		/// <summary>
		/// 法線の正規化。
		/// </summary>
		public void Normalize() {
			Normal.Normalize();
		}
	}

	public partial struct Plane {
		/// <summary>
		/// 法線との内積。
		/// </summary>
		/// <param name="value"></param>
		/// <param name="result"></param>
		public void Dot(ref Vector3 value, out float result) {
			Vector3.Dot(ref Normal, ref value, out result);
		}
		/// <summary>
		/// 法線との内積。
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public float Dot(Vector3 value) {
			float result;
			Dot(ref value, out result);
			return result;
		}
	}

	public partial struct Plane {
		/// <summary>
		/// 法線との内積にDを加算した値。
		/// </summary>
		/// <param name="value"></param>
		/// <param name="result"></param>
		public void DotCoordinate(ref Vector3 value, out float result) {
			Vector3.Dot(ref Normal, ref value, out result);
			result += D;
		}
		/// <summary>
		/// 法線との内積にDを加算した値。
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public float DotCoordinate(Vector3 value) {
			float result;
			DotCoordinate(ref value, out result);
			return result;
		}
	}

}
