﻿
namespace XELF.Framework {

	public partial struct Matrix {
		/// <summary>
		/// 転置
		/// </summary>
		public static void Transpose(ref Matrix a, out Matrix result) {
			result = new Matrix();
			result.M11 = a.M11; result.M12 = a.M21; result.M13 = a.M31; result.M14 = a.M41;
			result.M21 = a.M12; result.M22 = a.M22; result.M23 = a.M32; result.M24 = a.M42;
			result.M31 = a.M13; result.M32 = a.M23; result.M33 = a.M33; result.M34 = a.M43;
			result.M41 = a.M14; result.M42 = a.M24; result.M43 = a.M34; result.M44 = a.M44;
		}
		/// <summary>
		/// 転置
		/// </summary>
		public static Matrix Transpose(Matrix a) {
			var result = new Matrix();
			result.M11 = a.M11; result.M12 = a.M21; result.M13 = a.M31; result.M14 = a.M41;
			result.M21 = a.M12; result.M22 = a.M22; result.M23 = a.M32; result.M24 = a.M42;
			result.M31 = a.M13; result.M32 = a.M23; result.M33 = a.M33; result.M34 = a.M43;
			result.M41 = a.M14; result.M42 = a.M24; result.M43 = a.M34; result.M44 = a.M44;
			return result;
		}
	}

}
