﻿
namespace XELF.Framework {

	public partial struct Matrix {
		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <param name="result"></param>
		public static void Multiply(ref Matrix a, float b, out Matrix result) {
			result = new Matrix(
				a.M11 * b, a.M12 * b, a.M13 * b, a.M14 * b,
				a.M21 * b, a.M22 * b, a.M23 * b, a.M24 * b,
				a.M31 * b, a.M32 * b, a.M33 * b, a.M34 * b,
				a.M41 * b, a.M42 * b, a.M43 * b, a.M44 * b);
		}
		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static Matrix operator *(Matrix a, float b) {
			Matrix result;
			Multiply(ref a, b, out result);
			return result;
		}
		/// <summary>
		/// 乗算
		/// </summary>
		/// <param name="a"></param>
		/// <param name="b"></param>
		/// <returns></returns>
		public static Matrix operator *(float a, Matrix b) {
			Matrix result;
			Multiply(ref b, a, out result);
			return result;
		}
	}

}
