﻿
namespace XELF.Framework {

	public partial struct Matrix {
		/// <summary>
		/// 並行移動の行列を作る。
		/// </summary>
		/// <param name="x">X</param>
		/// <param name="y">Y</param>
		/// <param name="z">Z</param>
		/// <param name="result"></param>
		public static void CreateTranslation(float x, float y, float z, out Matrix result) {
			result = new Matrix();
			result.M11 = 1; result.M12 = 0; result.M13 = 0; result.M14 = 0;
			result.M21 = 0; result.M22 = 1; result.M23 = 0; result.M24 = 0;
			result.M31 = 0; result.M32 = 0; result.M33 = 1; result.M34 = 0;
			result.M41 = x; result.M42 = y; result.M43 = z; result.M44 = 1;
		}
		/// <summary>
		/// 並行移動の行列を作る。
		/// </summary>
		/// <param name="translation">並行移動</param>
		/// <param name="result"></param>
		public static void CreateTranslation(ref Vector3 translation, out Matrix result) {
			CreateTranslation(translation.X, translation.Y, translation.Z, out result);
		}
	}

}
