﻿using System;

namespace XELF.Framework {

	public partial struct Matrix {
		/// <summary>
		/// X軸周りの回転
		/// </summary>
		/// <param name="radians"></param>
		/// <returns></returns>
		public static Matrix CreateRotationX(float radians) {
			var c = (float)Math.Cos(radians);
			var s = (float)Math.Sin(radians);
			return new Matrix(
				+1, 0, 0, 0,
				 0, +c, +s, 0,
				 0, -s, +c, 0,
				 0, 0, 0, +1);
		}
	}

	public partial struct Matrix {
		/// <summary>
		/// Y軸周りの回転
		/// </summary>
		/// <param name="radians"></param>
		/// <returns></returns>
		public static Matrix CreateRotationY(float radians) {
			var c = (float)Math.Cos(radians);
			var s = (float)Math.Sin(radians);
			return new Matrix(
				+c, 0, -s, 0,
				 0, +1, 0, 0,
				+s, 0, +c, 0,
				 0, 0, 0, +1);
		}
	}

	public partial struct Matrix {
		/// <summary>
		/// Z軸周りの回転
		/// </summary>
		/// <param name="radians"></param>
		/// <returns></returns>
		public static Matrix CreateRotationZ(float radians) {
			var c = (float)Math.Cos(radians);
			var s = (float)Math.Sin(radians);
			return new Matrix(
				+c, +s, 0, 0,
				-s, +c, 0, 0,
				 0, 0, +1, 0,
				 0, 0, 0, +1);
		}
	}

}
