﻿
namespace XELF.Framework {

	public partial struct Matrix {
		/// <summary>
		/// 回転クォータニオンから4行4列行列を作る。
		/// </summary>
		/// <param name="q"></param>
		/// <param name="m"></param>
		public static void CreateFromQuaternion(ref Quaternion q, out Matrix m) {
			Quaternion q0;
			Quaternion.Add(ref q, ref q, out q0);
			Quaternion q1 = new Quaternion(q0.X * q.X, q0.Y * q.Y, q0.Z * q.Z, q0.W * q.W);
			float xy = q0.X * q.Y;
			float wz = q0.W * q.Z;
			float xz = q0.X * q.Z;
			float wy = q0.W * q.Y;
			float yz = q0.Y * q.Z;
			float wx = q0.W * q.X;
			m = new Matrix();
			m.M11 = 1 - q1.Y - q1.Z;
			m.M12 = xy + wz;
			m.M13 = xz - wy;
			m.M21 = xy - wz;
			m.M22 = 1 - q1.X - q1.Z;
			m.M23 = yz + wx;
			m.M31 = xz + wy;
			m.M32 = yz - wx;
			m.M33 = 1 - q1.X - q1.Y;
			m.M14 = 0; m.M24 = 0; m.M34 = 0;
			m.M41 = 0; m.M42 = 0; m.M43 = 0; m.M44 = 1;
		}
	}

}
