﻿using System;

namespace XELF.Framework {

	public partial struct Matrix {
		/// <summary>
		/// 軸周りの回転から回転行列を作る。
		/// </summary>
		/// <param name="axis">軸</param>
		/// <param name="angle">角度[Radian]</param>
		/// <returns>回転行列</returns>
		public static Matrix CreateFromAxisAngle(Vector3 axis, float angle) {
			var c = (float)Math.Cos(angle);
			var s = (float)Math.Sin(angle);
			var i = 1 - c;
			var xs = axis.X * s;
			var ys = axis.Y * s;
			var zs = axis.Z * s;
			var xi = axis.X * i;
			var yi = axis.Y * i;
			var zi = axis.Z * i;
			var xx = xi * axis.X;
			var yy = yi * axis.Y;
			var zz = zi * axis.Z;
			var xy = xi * axis.Y;
			var yz = yi * axis.Z;
			var zx = zi * axis.X;

			return new Matrix(
				xx + c, xy + zs, zx - ys, 0,
				xy - zs, yy + c, yz + xs, 0,
				zx + ys, yz - xs, zz + c, 0,
				0, 0, 0, 1);
		}
	}

}
