﻿
using System;

namespace XELF.Framework {

	/// <summary>
	/// 数学補助
	/// </summary>
	public static partial class MathHelper {

		/// <summary>
		/// 平方根の逆数
		/// </summary>
		/// <param name="x"></param>
		/// <returns></returns>
		public static float Rsqrt(float x) {
			return (float)(1.0f / (float)Math.Sqrt(x));
			//if (x == 0) return float.NaN;
			//return unchecked((float)(1.0f / (float)Math.Sqrt(x)));
		}
		/// <summary>
		/// 逆数
		/// </summary>
		/// <param name="x"></param>
		/// <returns></returns>
		public static float Rcp(float x) {
			return unchecked(1.0f / x);
		}
#if !XNA
		/// <summary>
		/// クランプする。
		/// </summary>
		/// <param name="value">元の値</param>
		/// <param name="min">最小</param>
		/// <param name="max">最大</param>
		/// <returns></returns>
		public static float Clamp(float value, float min, float max) {
			return Math.Min(Math.Max(value, min), max);
		}
#endif
		/// <summary>
		/// 円周率
		/// </summary>
		public const float Pi = (float)Math.PI;
	}

}
