
using System;
using System.Collections.Generic;
#if XNA
using Microsoft.Xna.Framework;
using XnaMathHelper = Microsoft.Xna.Framework.MathHelper;
using Microsoft.Xna.Framework.Content;
#else
using XnaMathHelper = XELF.Framework.MathHelper;
using QuaternionHelper = XELF.Framework.Quaternion;
#endif

#if XNA

namespace XELF.Framework {

	/// <summary>
	/// pi]ƈʒuj
	/// </summary>
	public struct Pose {
		/// <summary>
		/// ʒu
		/// </summary>
		public Vector3 Position;
		/// <summary>
		/// ]
		/// </summary>
		public Quaternion Rotation;
		/// <summary>
		/// ϊs
		/// </summary>
		public Matrix Transform {
			get {
				Matrix transform;
				Matrix.CreateFromQuaternion(ref Rotation, out transform);
				transform.Translation = Position;
				return transform;
			}
		}
	}
	/// <summary>
	/// Aj[ṼL[
	/// </summary>
	public struct AnimationKey {
		/// <summary>
		/// 
		/// </summary>
		public float Time;
		/// <summary>
		/// p
		/// </summary>
		public Pose Pose;
	}

	/// <summary>
	/// Aj[ṼL[Xg
	/// </summary>
	public class AnimationKeys {
		/// <summary>
		/// RXgN^
		/// </summary>
		public AnimationKeys() {
			Weight = 1;
		}

		/// <summary>
		/// {[̖O
		/// </summary>
		public string Bone { get; set; }
		/// <summary>
		/// [VufBȌd݂Â
		/// </summary>
		public float Weight { get; set; }

		/// <summary>
		/// L[Xgݒ肷B
		/// </summary>
		/// <param name="keys"></param>
		public void SetKeys(List<AnimationKey> keys) {
			Keys = keys.ToArray();
		}
		/// <summary>
		/// \𓾂B
		/// </summary>
		/// <returns></returns>
		public override string ToString() {
			return string.Format("AnimationKeys{{Bone={0}}}", Bone);
		}

		[ContentSerializer]
		AnimationKey[] Keys;
		[ContentSerializer]
		int currentIndex;
		/// <summary>
		/// L[̃Xg
		/// </summary>
		public AnimationKey[] Items { get { return Keys; } }

		void GetQuadIndices(int index, out int i0, out int i1, out int i2, out int i3) {
			var i = index + Count;
			i0 = (i - 1) % Count;
			i1 = (i) % Count;
			i2 = (i + 1) % Count;
			i3 = (i + 2) % Count;
		}

		int Count { get { return Keys.Length; } }

		/// <summary>
		/// Ԓ
		/// </summary>
		public float Duration { get; set; }

		/// <summary>
		/// Ԃɂ⊮ꂽp擾B
		/// </summary>
		/// <param name="time"></param>
		/// <returns></returns>
		public Pose this[float time] {
			get {
				currentIndex = Math.Min(currentIndex, Keys.Length - 1);
				for (; currentIndex >= 0; currentIndex--) {
					if (time >= Keys[currentIndex].Time) {
						break;
					}
				}
				currentIndex = Math.Max(currentIndex, 0);
				for (; currentIndex < Keys.Length; currentIndex++) {
					if (time < Keys[currentIndex].Time) {
						currentIndex--;
						break;
					}
				}

				int i0, i1, i2, i3;
				GetQuadIndices(currentIndex, out i0, out i1, out i2, out i3);

				float amount;
				float time0 = Keys[i1].Time;
				if (i2 > i1) {
					var t = time - time0;
					if (t < 0) t = 0;
					amount = (time - time0) / (Keys[i2].Time - time0);
				} else {
					amount = (time - time0) / ((Duration - Keys[i2].Time) - time0);
				}
				amount = XnaMathHelper.Clamp(amount, 0, 1);

				Pose result;

				var r0 = Keys[i0].Pose.Rotation;
				var r1 = Keys[i1].Pose.Rotation;
				var r2 = Keys[i2].Pose.Rotation;
				var r3 = Keys[i3].Pose.Rotation;
				float a1, a2, a3;
				Quaternion.Dot(ref r0, ref r1, out a1);
				Quaternion.Dot(ref r1, ref r2, out a2);
				Quaternion.Dot(ref r2, ref r3, out a3);
				if (a1 < 0) Quaternion.Negate(ref r1, out r1);
				if (a2 < 0) Quaternion.Negate(ref r2, out r2);
				if (a3 < 0) Quaternion.Negate(ref r3, out r3);

				QuaternionHelper.CatmullRom(
					ref r0,
					ref r1,
					ref r2,
					ref r3, amount, out result.Rotation);
				Vector3.CatmullRom(
					ref Keys[i0].Pose.Position,
					ref Keys[i1].Pose.Position,
					ref Keys[i2].Pose.Position,
					ref Keys[i3].Pose.Position, amount, out result.Position);

				return result;
			}
		}
	}

}

#endif
